local t = Def.ActorFrame {}
local cx = SCREEN_CENTER_X;
local cy = SCREEN_CENTER_Y;
local song = GAMESTATE:GetCurrentSong();
local jkt = song:GetJacketPath();
local sname = song:GetDisplayMainTitle();
local ssname = song:GetDisplaySubTitle();
if ssname == "" then ssname = nil end
local sartist = song:GetDisplayArtist();

t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#000000")):diffusealpha(1) end;
};
t[#t+1] = LoadActor("grid_max")..{
	InitCommand=function(self) self:Center():FullScreen():diffusealpha(0) end;
	OnCommand=function(self) self:sleep(0.3):queuecommand("FadePulse"):queuecommand("FadePulse"):queuecommand("FadePulse") end;
	FadePulseCommand=function(self) self:smooth(0.5):diffusealpha(0.8):smooth(0.5):diffusealpha(0.2):smooth(0.5):diffusealpha(0.8):smooth(0.5):diffusealpha(0.2) end;
};
t[#t+1] = LoadActor("_nine")..{
	InitCommand=function(self) self:xy(cx-83,cy-300) end;
	OnCommand=function(self) self:sleep(1):accelerate(0.4):addy(333):sleep(1.6):accelerate(0.2):addy(100):zoom(0.8):sleep(3):linear(0.3):diffusealpha(0) end;
};
t[#t+1] = LoadActor("_nine")..{
	InitCommand=function(self) self:xy(cx,cy-300) end;
	OnCommand=function(self) self:sleep(1.6):accelerate(0.4):addy(333):sleep(1):accelerate(0.2):addy(100):zoom(0.8):sleep(3):linear(0.3):diffusealpha(0) end;
};
t[#t+1] = LoadActor("_nine")..{
	InitCommand=function(self) self:xy(cx+83,cy-300) end;
	OnCommand=function(self) self:sleep(2.2):accelerate(0.4):addy(333):sleep(0.4):accelerate(0.2):addy(100):zoom(0.8):sleep(3):linear(0.3):diffusealpha(0) end;
};
--[[t[#t+1] = LoadActor("_full")..{
	InitCommand=function(self) self:xy(cx,cy+100):zoom(0.8):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.2):diffusealpha(1) end;
};]]
t[#t+1] = Def.ActorFrame {
	InitCommand=function(self) self:addy(-50) end;
	LoadActor("../_jacketframe")..{
		Condition=GAMESTATE:GetCurrentSong():GetJacketPath();
		InitCommand=function(self) self:Center():zoom(0.8):diffusealpha(0):sleep(3.2):diffusealpha(1):sleep(3):linear(0.3):diffusealpha(0) end;
	};

	LoadActor(jkt)..{
		InitCommand=function(self) self:Center():diffusealpha(0) end;
		OnCommand=function(self) self:sleep(3.2):diffusealpha(1):scaletofit(cx-79,cy-79,cx+79,cy+79):sleep(3):linear(0.3):diffusealpha(0) end;
	};
	Def.ActorFrame {
		InitCommand=function(self) self:Center():addy(120):zoom(0.8):diffusealpha(0) end;
		OnCommand=function(self) self:sleep(3.2):diffusealpha(1):sleep(3):linear(0.3):diffusealpha(0) end;
			LoadFont("_pixellari 32px")..{
				InitCommand=function(self)
					if ssname ~= nil then -- main and sub title
						self:settextf("%s\n\n%s",sname,ssname):addy(-10):zoom(0.7)
					elseif ssname == nil then -- main title
						self:settext(sname):addy(-15):zoom(0.9)
					end
				end;
			};
			LoadFont("_pixellari 32px")..{
				InitCommand=function(self)
					if ssname then 
						self:maxwidth(700):addy(23):zoom(0.9)
					else
						self:maxwidth(700):addy(18)
					end
				end;
				OnCommand=function(self) self:settext(sartist) end;
			};
	};
};


t[#t+1] = LoadActor("longwarning")..{
	InitCommand=function(self) self:sleep(0.2):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};

t[#t+1] = LoadActor("land")..{
	InitCommand=function(self) self:sleep(1.3):queuecommand("Play"):sleep(0.6):queuecommand("Play"):sleep(0.6):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};

t[#t+1] = LoadActor("boom")..{
	InitCommand=function(self) self:sleep(3.1):queuecommand("Play") end;
	PlayCommand=function(self) self:play() end;
};
t[#t+1] = Def.Quad {
	InitCommand=function(self) self:Center():FullScreen():diffuse(color("#FF0000")):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.2):diffusealpha(1):linear(0.5):diffusealpha(0) end;
};
return t;